using System;
using System.Data;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/07/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		/// Class provides static methods to retrieve blood test type data from the VBECS database.
		///</summary>

		#endregion

	public class BloodTestType
	{

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/20/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="828"> 
		///		<ExpectedInput>OrderableTestId string</ExpectedInput>
		///		<ExpectedOutput>DataTable with BloodTests for the order</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="829"> 
		///		<ExpectedInput>Invalid OrderableTestId </ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		///	Retrieves from database list of available blood test types for specified orderable test.
		///</summary>
		///<param name="orderableTestId">Orderable test ID</param>
		public static DataTable GetBloodTestTypes(string orderableTestId)
		{
			SqlParameter prm =	new SqlParameter( STOREDPROC.GetBloodTestTypes.orderabletestid, System.Data.SqlDbType.VarChar );
			
			prm.Value = orderableTestId;

			return StoredProcedure.GetDataTable( STOREDPROC.GetBloodTestTypes.StoredProcName, prm );
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/20/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="830"> 
		///		<ExpectedInput>BloodTestTypeId</ExpectedInput>
		///		<ExpectedOutput>DataTabe with BloodTest info</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="831"> 
		///		<ExpectedInput>Invalid BloodTestTypeId </ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		///	Retrieves data from database for a specified single blood test type. 
		///</summary>
		///<param name="bloodTestTypeId">Blood test type ID</param>
		public static DataTable GetBloodTestType( int bloodTestTypeId )
        {
            SqlParameter prm = new SqlParameter( STOREDPROC.GetBloodTestType.bloodtesttypeid, SqlDbType.Int );
            
			prm.Value = bloodTestTypeId;

			return Common.StoredProcedure.GetDataTable( STOREDPROC.GetBloodTestType.StoredProcName, prm );
        }
	}
}
